using System;

namespace Takmicenje
{
    class Slicice
    {
        static void Eratosten(out bool[] prost, long n)
        {
            prost = new bool[n + 1];

            for (long i = 0; i <= n; i++) prost[i] = true;

            prost[0] = prost[1] = false;

            for (long i = 2; i * i <= n; i++) {
                if (prost[i]) {
                    for (long j = i * i; j <= n; j += i) prost[j] = false;
                }
            }
        }

        static long nedostupneSlicice(long n, bool[] prost) 
        { 
            long br = 1;

            long pocetak = n / 2 + 1;
            if (pocetak % 2 == 0) pocetak++;

            for (long i = pocetak; i <= n; i += 2) {
                if (prost[i]) br++;
            }           
            return br;
        }

        static void Main(string[] args)
        {

            //Korak 1 - ucitavamo q

            long q = long.Parse(Console.ReadLine());

            //Korak 2 - za svako pitanje racunamo broj razmenjivih slicica

            long N = (long)Math.Pow(10, 7);
            bool[] prost;
            Eratosten(out prost, N);

            for (long i = 0; i < q; i++) {

                long n = long.Parse(Console.ReadLine());
                long nerazmenjive = nedostupneSlicice(n, prost);
                long razlicite = n - nerazmenjive;
                Console.WriteLine(razlicite);
            }
        }
    }
}